#include <SPI.h>
#include "LCD_Driver.h"
#include "GUI_Paint.h"
#include "image.h"

#include "Adafruit_PM25AQI.h"
#include <SoftwareSerial.h>
SoftwareSerial pmSerial(2, 3);

Adafruit_PM25AQI aqi = Adafruit_PM25AQI();

// Define a variable to track the current state
// 0 for happy, 1 for sad, -1 for initial state
int currentState = -1;

void setup() {
    Config_Init();
    LCD_Init();

    LCD_SetBacklight(100);

    // Dust sensor setup
    Serial.begin(115200);
    while (!Serial) delay(10);
    delay(1000);
    pmSerial.begin(9600);
    if (!aqi.begin_UART(&pmSerial)) { // connect to the sensor over software serial
        Serial.println("Could not find PM 2.5 sensor!");
        while (1) delay(10);
    }

    Serial.println("PM25 found!");
}

void loop() {
    PM25_AQI_Data data;

    if (aqi.read(&data)) {
        Serial.println("AQI reading success");
        Serial.print(F("Concentration Units (environmental): "));
        Serial.print(F("\t\tPM 2.5: "));
        Serial.print(data.pm25_env);
        Serial.println(F("Particles > 2.5um / 0.1L air:"));
        Serial.println(data.particles_25um);
        Serial.println(F("---------------------------------------"));

        int newState;
        if (data.pm25_env > 10) {
            newState = 1; // Sad state
        } else {
            newState = 0; // Happy state
        }

        // Check if the state has changed
        if (currentState != newState) {
            currentState = newState;

            // Clear the screen and draw the new state
            Paint_NewImage(LCD_WIDTH, LCD_HEIGHT, 90, WHITE);
            Paint_Clear(WHITE);

            if (currentState == 1) {
                // Draw sad face
   Paint_DrawCircle(140, 210, 60, ORANGE, DOT_PIXEL_4X4, DRAW_FILL_EMPTY);
    Paint_DrawRectangle(75, 205, 205, 240, WHITE, DOT_PIXEL_1X1, DRAW_FILL_FULL);
    // eyebrows
    Paint_DrawLine(65, 40, 25, 55, GRAY, DOT_PIXEL_3X3, LINE_STYLE_SOLID);
    Paint_DrawLine(215, 40, 255, 55, GRAY, DOT_PIXEL_3X3, LINE_STYLE_SOLID);
    // eyes
    Paint_DrawCircle(50, 100, 35, GRAY, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(50, 100, 30, ORANGE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(65, 85, 8, WHITE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(230, 100, 35, GRAY, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(230, 100, 30, ORANGE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(245, 85, 8, WHITE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    // tears
    Paint_DrawLine(40, 127, 30, 170, DARKBLUE, DOT_PIXEL_4X4, LINE_STYLE_SOLID);
    Paint_DrawCircle(30, 170, 10, DARKBLUE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawLine(240, 127, 250, 170, DARKBLUE, DOT_PIXEL_4X4, LINE_STYLE_SOLID);
    Paint_DrawCircle(250, 170, 10, DARKBLUE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    // eyebrows
    Paint_DrawCircle(50, 60, 20, LIGHTBLUE, DOT_PIXEL_2X2, DRAW_FILL_EMPTY);
    Paint_DrawRectangle(25, 55, 75, 85, WHITE, DOT_PIXEL_1X1, DRAW_FILL_FULL);
    Paint_DrawCircle(230, 60, 20, LIGHTBLUE, DOT_PIXEL_2X2, DRAW_FILL_EMPTY);
    Paint_DrawRectangle(205, 55, 255, 85, WHITE, DOT_PIXEL_1X1, DRAW_FILL_FULL);
    // eyes
    Paint_DrawCircle(50, 100, 35, LIGHTBLUE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(50, 100, 30, DARKBLUE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(65, 85, 8, WHITE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(230, 100, 35, LIGHTBLUE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(230, 100, 30, DARKBLUE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(245, 85, 8, WHITE, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    // blush
    Paint_DrawCircle(30, 137, 20, BLUSH, DOT_PIXEL_2X2, DRAW_FILL_FULL);
    Paint_DrawCircle(250, 137, 20, BLUSH, DOT_PIXEL_2X2, DRAW_FILL_FULL);
            }
        }
    } else {
        Serial.println("Could not read from AQI");
        delay(500);  // try again in a bit!
    }
}
